USE [DownloadStatistics]
GO

/****** Object:  Table [dbo].[Project]    Script Date: 8/2/2013 10:46:06 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[Project](
	[ID] [int] NOT NULL,
	[GameID] [int] NOT NULL,
	[PopularityScore] [decimal](19, 9) NULL,
	[PopularityRank] [int] NULL,
	[GamePopularityRank] [int] NULL,
	[DownloadsLastThirtyDays] [int] NULL,
	[UniqueDownloadsLastThirtyDays] [int] NULL,
	[TotalDownloads] [int] NULL,
	[DateModified] [datetime] NULL,
	[DatePopularityModified] [datetime] NULL,
	[HistoricalDownloads] [int] NULL,
 CONSTRAINT [PK_Project] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

ALTER TABLE [dbo].[Project] ADD  CONSTRAINT [DF_Project_PopularityScore]  DEFAULT ((0)) FOR [PopularityScore]
GO

ALTER TABLE [dbo].[Project] ADD  CONSTRAINT [DF_Project_PopularityRank]  DEFAULT ((0)) FOR [PopularityRank]
GO

ALTER TABLE [dbo].[Project] ADD  CONSTRAINT [DF_Project_GamePopularityRank]  DEFAULT ((0)) FOR [GamePopularityRank]
GO

ALTER TABLE [dbo].[Project] ADD  CONSTRAINT [DF_Project_DownloadsLastThirtyDays]  DEFAULT ((0)) FOR [DownloadsLastThirtyDays]
GO

ALTER TABLE [dbo].[Project] ADD  CONSTRAINT [DF_Project_UniqueDownloadsLastThirtyDays]  DEFAULT ((0)) FOR [UniqueDownloadsLastThirtyDays]
GO

ALTER TABLE [dbo].[Project] ADD  CONSTRAINT [DF_Project_TotalDownloads]  DEFAULT ((0)) FOR [TotalDownloads]
GO

ALTER TABLE [dbo].[Project] ADD  CONSTRAINT [DF_Project_DateModified]  DEFAULT (getutcdate()) FOR [DateModified]
GO

ALTER TABLE [dbo].[Project] ADD  CONSTRAINT [DF_Project_HistoricalDownloads]  DEFAULT ((0)) FOR [HistoricalDownloads]
GO


